<?php

namespace App\Http\Controllers;

use App\MakeProduct;
use App\Product;
use App\Warehouse;
use App\Product_Warehouse;
use App\MakeProductUnits;
use App\Unit;
use Illuminate\Http\Request;

class MakeProductController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
//
//        $getProducts = Product::where('is_active',true)->wherein('category_id',[11,12])->get();
//
//        $getWarehouse = Warehouse::where('is_active',true)->get();
//
//        foreach ($getWarehouse as $item){
//            foreach ($getProducts as $product){
//                Product_Warehouse::create([
//                    'product_id'=>$product->id,
//                    'warehouse_id'=>$item->id,
//                    'qty'=>1000,
//                ]);
//            }
//        }


        $lims_makeProduct_data = MakeProduct::where('is_active',true)
            ->with('product')
            ->latest()->get();

        return view('makeProduct/index',compact('lims_makeProduct_data'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        $is_sale_product = Product::where(['is_active'=>true])->wherehas('category',function ($query){
            $query->wherein('make',['both','make']);
        })
            ->orderby('id','DESC')->get();

        $no_sale_product = Product::where(['is_active'=>true])->wherehas('category',function ($query){
            $query->where('make','=','yes');
        })
            ->orderby('id','DESC')->get();

//        dd($no_sale_product);

        $lims_unit_data = Unit::where(['is_active'=>true])
            ->orderby('id','DESC')->get();


        return view('makeProduct/create',compact('is_sale_product',
            'no_sale_product','lims_unit_data'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       $data = $this->validate($request, [
            'product_id' => [
                'required'
            ],'notes'=>[
                'nullable'
           ]
        ]);

       $data['is_active'] = true;

       $store = MakeProduct::create($data);

       $count = count($request->product_id_);


        for ($i = 0; $i < $count; $i++) {
            $childArray = [];

            $childArray['product_id'] = $request->product_id_[$i];
            $childArray['unit_id'] = $request->unit_id[$i];
            $childArray['amount'] = $request->amount_[$i];
            $childArray['notes'] = $request->notes_[$i];
            $childArray['product_unit_id'] = $store->id;

//            $product_array = Product::whereIn('id',$request->product_id_)->pluck('qty')->toArray();
//
//
//            $min =  min($product_array);
//
//            return $min;

            MakeProductUnits::create($childArray);


        }


        return redirect('makeProduct');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $no_sale_product = Product::where(['is_active'=>true])->wherehas('category',function ($query){
            $query->where('make','=','yes');
        })
            ->orderby('id','DESC')->get();



        $lims_unit_data = Unit::where(['is_active'=>true])
            ->orderby('id','DESC')->get();

        return view('makeProduct/row',compact('id'
            ,'no_sale_product','lims_unit_data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $lims_make_data = MakeProduct::with('child.product')->findOrFail($id);


        $is_sale_product = Product::where(['is_active'=>true])->wherehas('category',function ($query){
            $query->wherein('make',['both','make']);
        })
            ->orderby('id','DESC')->get();

        $no_sale_product = Product::where(['is_active'=>true])->wherehas('category',function ($query){
            $query->where('make','=','yes');
        })
            ->orderby('id','DESC')->get();

        $lims_unit_data = Unit::where(['is_active'=>true])
            ->orderby('id','DESC')->get();

        return view('makeProduct/edit',compact('is_sale_product',
            'no_sale_product','lims_make_data','lims_unit_data'));


    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $data = $this->validate($request, [
            'product_id' => [
                'required'
            ],'notes'=>[
                'nullable'
            ]
        ]);

        $data['is_active'] = true;

         MakeProduct::find($id)->update($data);

        MakeProductUnits::where('product_unit_id',$id)->delete();

        $count = count($request->product_id_);


        for ($i = 0; $i < $count; $i++) {
            $childArray = [];

            $childArray['product_id'] = $request->product_id_[$i];
            $childArray['amount'] = $request->amount_[$i];
            $childArray['unit_id'] = $request->unit_id[$i];
            $childArray['notes'] = $request->notes_[$i];
            $childArray['product_unit_id'] = $id;
            MakeProductUnits::create($childArray);
        }

        return redirect('makeProduct');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $lims_make_data =  MakeProduct::findOrFail($id);
        $lims_make_data->is_active = 'no';
        $lims_make_data->save();

        return redirect('makeProduct')->with('not_permitted', 'Data deleted successfully');
    }//end fun

    public function deletebyselection(Request $request){
        foreach ($request->makeProductIdArray as $id){
            $lims_make_data =  MakeProduct::findOrFail($id);
            $lims_make_data->is_active = 'no';
            $lims_make_data->save();
        }
        return  'Data deleted successfully';
    }//end fun
}
