<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Tables;
use App\Floors;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;

class TablesController extends Controller
{
    public function index()
    {
        $tables = Tables::with('floor')->latest()->get();
        $floors = Floors::latest()->get();

        return view('table.index', compact('tables', 'floors'));
    }

    public function store(Request $request)
    {

        $data = $request->all();

        $photo = $request->photo;

        if ($photo) {
            $v = Validator::make(
                [
                    'extension' => strtolower($request->photo->getClientOriginalExtension()),
                ],
                [
                    'extension' => 'in:jpg,jpeg,png,gif,pdf,csv,docx,xlsx,txt',
                ]
            );
            if ($v->fails())
                return redirect()->back()->withErrors($v->errors());
            $ext = $photo->getClientOriginalExtension();
            $documentName = time().'--'.base64_encode($photo->getClientOriginalName()).'.'.$ext;
            $photo->move('public/tables/', $documentName);
            $data['photo'] = 'public/tables/'.$documentName;
        }
        Tables::create($data);

        return redirect('tables')->with('message', 'Table created successfully');

    }

    public function edit($id)
    {

        $find = Tables::findOrFail($id);
        $Floors = Floors::latest()->get();


        $out = '<option selected disabled>' . trans('file.Floor') . '</option>';
        foreach ($Floors as $Floors) {
            $select = '';
            if ($Floors->id == $find->floor_id) {
                $select = 'selected';
            }
            $out .= '<option value="' . $Floors->id . '" ' . $select . ' >' . $Floors->name . '</option>';
        }
        $find->html = $out;
        return $find;

    }


    public function update(Request $request)
    {
        $data = $request->except(['id', 'photo']);

        $tables = Tables::find($request->id);

        $photo = $request->file('photo');

        if ($photo) {
            Storage::delete($tables->photo);
            $ext = $photo->getClientOriginalExtension();
            $documentName = time().'--'.base64_encode($photo->getClientOriginalName()).'.'.$ext;
            $photo->move('public/tables/', $documentName);
            $data['photo'] = 'public/tables/'.$documentName;
        }

        $tables->update($data);

        return redirect('tables')->with('message', 'Data updated successfully');
    }


    public function destroy($id)
    {
        $tables = Tables::find($id);
        $tables->delete();
        return redirect('table')->with('message', 'Table Deleted successfully');
    }

    public function QRC()
    {
        $tables = Tables::get();
        $Floors = Floors::latest()->get();

        return view('table.QRC', compact('tables', 'Floors'));
    }
}
