<?php $__env->startSection('content'); ?>
    <?php if($errors->has('name')): ?>
        <div class="alert alert-danger alert-dismissible text-center">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><?php echo e($errors->first('name')); ?></div>
    <?php endif; ?>
    <?php if(session()->has('message')): ?>
        <div class="alert alert-success alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><?php echo e(session()->get('message')); ?></div>
    <?php endif; ?>
    <?php if(session()->has('not_permitted')): ?>
        <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><?php echo e(session()->get('not_permitted')); ?></div>
    <?php endif; ?>

    <section>




        <div class="container-fluid">
            <div class="card">

                <?php echo Form::open(['route' => 'productionLine.index', 'method' => 'get']); ?>

                <div class="row mb-3">
                    <div class="col-md-4 offset-md-2 mt-3">
                        <div class="form-group row">
                            <label class="d-tc mt-2"><strong><?php echo e(trans('file.Choose Your Date')); ?></strong> &nbsp;</label>
                            <div class="d-tc">
                                <div class="input-group">
                                    <input type="text" class="daterangepicker-field form-control" value="<?php echo e($starting_date); ?> To <?php echo e($ending_date); ?>" required />
                                    <input type="hidden" name="starting_date" value="<?php echo e($starting_date); ?>" />
                                    <input type="hidden" name="ending_date" value="<?php echo e($ending_date); ?>" />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 mt-3 <?php if(\Auth::user()->role_id > 2): ?><?php echo e('d-none'); ?><?php endif; ?>">
                        <div class="form-group row">
                            <label class="d-tc mt-2"><strong><?php echo e(trans('file.Choose Warehouse')); ?></strong> &nbsp;</label>
                            <div class="d-tc">
                                <select id="warehouse_id" name="warehouse_id" class="selectpicker form-control" data-live-search="true" data-live-search-style="begins" >
                                    <option value="0"><?php echo e(trans('file.All Warehouse')); ?></option>
                                    <?php $__currentLoopData = $lims_warehouse_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($warehouse->id == $warehouse_id): ?>
                                            <option selected value="<?php echo e($warehouse->id); ?>"><?php echo e($warehouse->name); ?></option>
                                        <?php else: ?>
                                            <option value="<?php echo e($warehouse->id); ?>"><?php echo e($warehouse->name); ?></option>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2 mt-3">
                        <div class="form-group">
                            <button class="btn btn-primary" id="filter-btn" type="submit"><?php echo e(trans('file.submit')); ?></button>
                        </div>
                    </div>
                </div>
                <?php echo Form::close(); ?>

            </div>
        </div>
        <div class="table-responsive">
            <table id="branch-table" class="table">
                <thead>
                <tr>
                    <th class="not-exported"></th>
                    <th><?php echo e(trans('file.product')); ?></th>
                    <th ><?php echo e(trans('file.Warehouse')); ?></th>
                    <th ><?php echo e(trans('file.amount')); ?></th>
                    <th ><?php echo e(trans('file.waste')); ?></th>
                    <th ><?php echo e(trans('file.notes')); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $lims_productionUnit_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$productionUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <tr data-id="<?php echo e($productionUnit->id); ?>">
                        <td><?php echo e($key); ?></td>
                        <td><?php echo e($productionUnit->product->name??''); ?></td>
                        <td><?php echo e($productionUnit->warehouse->name??''); ?></td>
                        <td><?php echo e($productionUnit->amount??''); ?></td>
                        <td><?php echo e($productionUnit->waste??''); ?></td>
                        <td><?php echo e($productionUnit->notes??''); ?></td>
                        
                        
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </section>


    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    

    <script type="text/javascript">

        $("ul#MakeProduct").siblings('a').attr('aria-expanded','true');
        $("ul#MakeProduct").addClass("show");
        $("ul#MakeProduct #productionLine-menu").addClass("active");

        var make_product_id = [];
        var user_verified = <?php echo json_encode(env('USER_VERIFIED')) ?>;

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        function confirmDelete() {
            if (confirm("Are you sure want to delete?")) {
                return true;
            }
            return false;
        }

        $(document).ready(function() {

            $(document).on('click', '.open-EditbranchDialog', function() {
                var url = "branch/"
                var id = $(this).data('id').toString();
                url = url.concat(id).concat("/edit");

                $.get(url, function(data) {
                    $("#editModal input[name='name']").val(data['name']);
                    $("#editModal input[name='phone']").val(data['phone']);
                    $("#editModal input[name='email']").val(data['email']);
                    $("#editModal textarea[name='address']").val(data['address']);
                    $("#editModal input[name='make_product_id']").val(data['id']);

                    // companySelect
                    $('#companySelect').html(data['html'])
                    $('#companySelect').selectpicker('refresh')

                });
            });
        });

        $('#branch-table').DataTable( {
            "order": [],
            'language': {
                'lengthMenu': '_MENU_ <?php echo e(trans("file.records per page")); ?>',
                "info":      '<small><?php echo e(trans("file.Showing")); ?> _START_ - _END_ (_TOTAL_)</small>',
                "search":  '<?php echo e(trans("file.Search")); ?>',
                'paginate': {
                    'previous': '<i class="dripicons-chevron-left"></i>',
                    'next': '<i class="dripicons-chevron-right"></i>'
                }
            },
            'columnDefs': [
                {
                    "orderable": false,
                    // 'targets': [0, 6]
                },  {
                    'render': function(data, type, row, meta){
                        if(type === 'display'){
                            data = '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>';
                        }

                        return data;
                    },
                    'checkboxes': {
                        'selectRow': true,
                        'selectAllRender': '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>'
                    },
                    'targets': [0]
                }
            ],
            'select': { style: 'multi',  selector: 'td:first-child'},
            'lengthMenu': [[10, 25, 50, -1], [10, 25, 50, "All"]],
            dom: '<"row"lfB>rtip',
            buttons: [
                {
                    extend: 'pdf',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    extend: 'csv',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    extend: 'print',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    text: '<?php echo e(trans("file.delete")); ?>',
                    className: 'buttons-delete',
                    action: function ( e, dt, node, config ) {
                        if(user_verified == '1') {
                            make_product_id.length = 0;
                            $(':checkbox:checked').each(function(i){
                                if(i){
                                    make_product_id[i-1] = $(this).closest('tr').data('id');
                                }
                            });
                            if(make_product_id.length && confirm("Are you sure want to delete?")) {
                                $.ajax({
                                    type:'POST',
                                    url:'makeProduct/deletebyselection',
                                    data:{
                                        makeProductIdArray: make_product_id
                                    },
                                    success:function(data){
                                        alert(data);
                                    }
                                });
                                dt.rows({ page: 'current', selected: true }).remove().draw(false);
                            }
                            else if(!make_product_id.length)
                                alert('No row is selected!');
                        }
                        else
                            alert('This feature is disable for demo!');
                    }
                },
                {
                    extend: 'colvis',
                    columns: ':gt(0)'
                },
            ],
        } );

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $( "#select_all" ).on( "change", function() {
            if ($(this).is(':checked')) {
                $("tbody input[type='checkbox']").prop('checked', true);
            }
            else {
                $("tbody input[type='checkbox']").prop('checked', false);
            }
        });

        $("#export").on("click", function(e){
            e.preventDefault();
            var branch = [];
            $(':checkbox:checked').each(function(i){
                branch[i] = $(this).val();
            });
            $.ajax({
                type:'POST',
                url:'/exportbranch',
                data:{

                    branchArray: branch
                },
                success:function(data){
                    alert('Exported to CSV file successfully! Click Ok to download file');
                    window.location.href = data;
                }
            });
        });
        $('.selectpicker').selectpicker('refresh');
        $(".daterangepicker-field").daterangepicker({
            callback: function(startDate, endDate, period){
                var starting_date = startDate.format('YYYY-MM-DD');
                var ending_date = endDate.format('YYYY-MM-DD');
                var title = starting_date + ' To ' + ending_date;
                $(this).val(title);
                $('input[name="starting_date"]').val(starting_date);
                $('input[name="ending_date"]').val(ending_date);
            }
        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u657893346/domains/kidsstation.fun/public_html/AlyasmeenPOS/resources/views/productionLine/index.blade.php ENDPATH**/ ?>