<?php $__env->startSection('content'); ?>
    <?php if(session()->has('message')): ?>
        <div class="alert alert-success alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><?php echo session()->get('message'); ?></div>
    <?php endif; ?>
    <?php if(session()->has('not_permitted')): ?>
        <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><?php echo e(session()->get('not_permitted')); ?></div>
    <?php endif; ?>
    <section>
        <div class="container-fluid">
            <button class="btn btn-info" data-toggle="modal" data-target="#createModal"><i class="dripicons-plus"></i> <?php echo e(trans('file.Add Discount')); ?> </button>
        </div>
        <div class="table-responsive">
            <table id="discount-table" class="table">
                <thead>
                <tr>
                    <th class="not-exported"></th>
                    <th><?php echo e(trans('file.name')); ?></th>
                    <th><?php echo e(trans('file.value')); ?></th>
                    <th><?php echo e(trans('file.Type')); ?></th>
                    <th><?php echo e(trans('file.Date')); ?></th>
                    <th class="not-exported"><?php echo e(trans('file.action')); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $discounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>  $discount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                    ?>
                    <tr>
                        <td><?php echo e($key); ?></td>
                        <td><?php echo e($discount->title); ?></td>
                        <td><?php echo e($discount->value); ?></td>
                        <td><?php echo e($discount->type == 'val' ? '$' : '%'); ?></td>
                        <td><?php echo e($discount->created_at->format('Y-m-d H:i:s') ?? 'No date'); ?></td>
                        <td>
                            <div class="btn-group">
                                <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><?php echo e(trans('file.action')); ?>

                                    <span class="caret"></span>
                                    <span class="sr-only">Toggle Dropdown</span>
                                </button>
                                <ul class="dropdown-menu edit-options dropdown-menu-right dropdown-default" user="menu">
                                    <li>
                                        <button type="button" data-id="<?php echo e($discount->id); ?>" class="open-EditrewardsDialog btn btn-link" data-toggle="modal" data-target="#editModal"><i class="dripicons-document-edit"></i> <?php echo e(trans('file.edit')); ?>

                                        </button>
                                    </li>
                                    <li class="divider"></li>
                                    <?php echo e(Form::open(['route' => ['discounts.destroy', $discount->id], 'method' => 'DELETE'] )); ?>

                                    <li>
                                        <button type="submit" class="btn btn-link" onclick="return confirmDelete()"><i class="dripicons-trash"></i> <?php echo e(trans('file.delete')); ?></button>
                                    </li>
                                    <?php echo e(Form::close()); ?>

                                </ul>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </section>

    <div id="createModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" class="modal fade text-left">
        <div role="document" class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 id="exampleModalLabel" class="modal-title"><?php echo e(trans('file.Add Discount')); ?></h5>
                    <button type="button" data-dismiss="modal" aria-label="Close" class="close"><span aria-hidden="true"><i class="dripicons-cross"></i></span></button>
                </div>
                <div class="modal-body">
                    <p class="italic"><small><?php echo e(trans('file.The field labels marked with * are required input fields')); ?>.</small></p>
                    <?php echo Form::open(['route' => 'discounts.store', 'method' => 'post','enctype' => 'multipart/form-data']); ?>

                    <div class="row">
                        <div class="col-md-12 form-group">
                            <label><?php echo e(trans('file.name')); ?> *</label>
                            <input type="text" name="title" class="form-control"  required>
                        </div>

                        <div class="col-md-6 form-group">
                            <label><?php echo e(trans('file.value')); ?> *</label>
                            <input type="number" name="value" id="value" class="form-control" required>
                        </div>
                        <div class="col-md-6 form-group">
                            <label><?php echo e(trans('file.Type')); ?> *</label>
                            <select type="text" name="type" id="type" class="form-control" required>
                                <option value="" selected disabled><?php echo e(trans('file.Type')); ?></option>
                                <option value="per">Percent</option>
                                <option value="val">Value</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <button type="submit" class="btn btn-primary"><?php echo e(trans('file.submit')); ?></button>
                    </div>
                    <?php echo e(Form::close()); ?>

                </div>
            </div>
        </div>
    </div>

    <div id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" class="modal fade text-left">
        <div role="document" class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 id="exampleModalLabel" class="modal-title"><?php echo e(trans('file.Update Holiday')); ?></h5>
                    <button type="button" data-dismiss="modal" aria-label="Close" class="close"><span aria-hidden="true"><i class="dripicons-cross"></i></span></button>
                </div>
                <div class="modal-body">
                    <p class="italic"><small><?php echo e(trans('file.The field labels marked with * are required input fields')); ?>.</small></p>
                    <?php echo Form::open(['route' => ['discounts.update', 1], 'method' => 'put','enctype' => 'multipart/form-data']); ?>

                    <div class="row">
                        <input type="text" name="id" id="id" hidden>
                        <div class="col-md-12 form-group">
                            <label><?php echo e(trans('file.name')); ?> *</label>
                            <input type="text" name="title" class="form-control"  required>
                        </div>

                        <div class="col-md-6 form-group">
                            <label><?php echo e(trans('file.value')); ?> *</label>
                            <input type="number" name="value" id="value" class="form-control" required>
                        </div>
                        <div class="col-md-6 form-group">
                            <label><?php echo e(trans('file.Type')); ?> *</label>
                            <select type="text" name="type" id="type" class="form-control" required>
                                <option value="per">Percent</option>
                                <option value="val">Value</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <button type="submit" class="btn btn-primary"><?php echo e(trans('file.submit')); ?></button>
                    </div>
                    <?php echo e(Form::close()); ?>

                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">

        $("ul#setting").siblings('a').attr('aria-expanded','true');
        $("ul#setting").addClass("show");
        $("ul#setting #table-setting-menu").addClass("active");

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        function confirmDelete() {
            if (confirm("Are you sure want to delete?")) {
                return true;
            }
            return false;
        }

        var holiday_id = [];
        var user_verified = <?php echo json_encode(env('USER_VERIFIED')) ?>;

        var date = $('.date');
        date.datepicker({
            format: "dd-mm-yyyy",
            startDate: "<?php echo date('d-m-Y'); ?>",
            autoclose: true,
            todayHighlight: true
        });

        $(document).on('click', '.btn-approve', function() {
            var id = $(this).data('id');
            $.get('approve-holiday/'+id, function(data) {
                $('.btn-approve').addClass('d-none');
            });
        });



        $('#discount-table').DataTable( {
            "order": [],
            'language': {
                'lengthMenu': '_MENU_ <?php echo e(trans("file.records per page")); ?>',
                "info":      '<small><?php echo e(trans("file.Showing")); ?> _START_ - _END_ (_TOTAL_)</small>',
                "search":  '<?php echo e(trans("file.Search")); ?>',
                'paginate': {
                    'previous': '<i class="dripicons-chevron-left"></i>',
                    'next': '<i class="dripicons-chevron-right"></i>'
                }
            },
            'columnDefs': [
                {
                    "orderable": false,
                    'targets': [0, 4]
                },
                {
                    'render': function(data, type, row, meta){
                        if(type === 'display'){
                            data = '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>';
                        }

                        return data;
                    },
                    'checkboxes': {
                        'selectRow': true,
                        'selectAllRender': '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>'
                    },
                    'targets': [0]
                }
            ],
            'select': { style: 'multi',  selector: 'td:first-child'},
            'lengthMenu': [[10, 25, 50, -1], [10, 25, 50, "All"]],
            dom: '<"row"lfB>rtip',
            buttons: [
                {
                    extend: 'pdf',
                    text: '<?php echo e(trans("file.PDF")); ?>',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible',
                    }
                },
                {
                    extend: 'csv',
                    text: '<?php echo e(trans("file.CSV")); ?>',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible',
                    },
                },
                {
                    extend: 'print',
                    text: '<?php echo e(trans("file.Print")); ?>',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible',
                    },
                },
                {
                    extend: 'colvis',
                    text: '<?php echo e(trans("file.Column visibility")); ?>',
                    columns: ':gt(0)'
                },
            ],
        } );
    </script>
    <script>

        $(document).ready(function() {
            $(document).on('click', '.open-EditrewardsDialog', function() {
                var url = "discounts/"
                var id = $(this).data('id').toString();
                url = url.concat(id).concat("/edit");

                $.get(url, function(data) {
                    console.log(data)
                    $("#editModal input[name='title']").val(data['title']);
                    $("#editModal select[name='type']").val(data['type']);
                    $("#editModal input[name='id']").val(data['id']);
                    $("#editModal input[name='value']").val(data['value']);
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u657893346/domains/kidsstation.fun/public_html/saudipos/resources/views/discount/index.blade.php ENDPATH**/ ?>